package android.reader;


import android.util.Log;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.InvalidParameterException;
import java.util.Timer;
import java.util.TimerTask;

import android.media.AudioFormat;
import android.media.AudioManager;
import android.media.AudioTrack;
import android.media.SoundPool;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.view.View;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.EditText;
import android.reader.R;
import android.reader.Application;
import android.annotation.SuppressLint;
import android.app.Activity;

@SuppressLint({ "NewApi", "NewApi", "NewApi", "NewApi" })
public class CPUCardOperate extends Activity {
	EditText mReception;
    protected Application mApplication;
    protected ReaderAndroid mSerialPort;
    protected int handle;
    protected int address = 0x00;
    private SoundPool soundPool;
    private int loadId;
    
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.cpucard);
		
		soundPool = new SoundPool(3, AudioManager.STREAM_MUSIC, 100);       
		loadId = soundPool.load(CPUCardOperate.this, R.raw.card_mp3, 1);
 		
		setTitle("CPU Card Reader");
 		mReception = (EditText) findViewById(R.id.EditTextReception);			
		((Button)findViewById(R.id.btnClear)).setOnClickListener(btnOnClick);
		((Button)findViewById(R.id.btnRATS)).setOnClickListener(btnOnClick);
		((Button)findViewById(R.id.btnAPDU)).setOnClickListener(btnOnClick);
		
		mApplication = (Application) getApplication();
		try {
			mSerialPort = mApplication.getSerialPort();
			Log.i("ANDROID","getSerialPort end");
			handle = mSerialPort.getHandle();
			Log.i("ANDROID","mSerialPort.getHandle()");

		} catch (SecurityException e) {
			DisplayError(R.string.error_security);
		} catch (IOException e) {
			DisplayError(R.string.error_unknown);
		} catch (InvalidParameterException e) {
			DisplayError(R.string.error_configuration);
		}
		
		((CheckBox)findViewById(R.id.APDU_AutoFlag)).setChecked(false);
 		timer.schedule(task, 200, 300);
	}
	
	@Override
	protected void onDestroy() {
		timer.cancel();
		super.onDestroy();
	}
	
	 Timer timer = new Timer();     
	 Handler handler = new Handler(){
	    	public void handleMessage(Message msg) {   
	    		switch (msg.what) {       
	            case 1:                  	
	            	if ( ((CheckBox)findViewById(R.id.APDU_AutoFlag)).isChecked())
	            	{
	            		View v = (View)findViewById(R.id.btnAPDU);
	            		btnOnClick.onClick(v);
	            	}
	                break;
	            default:
	            	break;
	            }       
	            super.handleMessage(msg);   
	        }     
	 };   
	    
	 TimerTask task = new TimerTask(){
		 public void run() {   
			 Message message = new Message();       
			 message.what = 1;       
			 handler.sendMessage(message);     
		 }    
	 };
	 
	 /*   ʾ      */
     public void playWav() {
         int BITRATE = 22050;
         int WAVE_HEADER_SIZE = 44;
         int size;
         try {
               File file = new File(android.os.Environment.getExternalStorageDirectory().getAbsolutePath() + "/mp3/card.wav");
               if (file.exists()) {
                      size = (int)(file.length());
                      byte [] buff = new byte[size];
                      FileInputStream inputStream = new FileInputStream(file);
                      inputStream.read(buff);
                      if (buff != null) {
                             AudioTrack at = null;
                             int intSize = android.media.AudioTrack.getMinBufferSize(BITRATE,
                                          AudioFormat.CHANNEL_CONFIGURATION_STEREO,
                                          AudioFormat.ENCODING_PCM_16BIT);
                             at = new AudioTrack(AudioManager.STREAM_SYSTEM,
                                          BITRATE,
                                          AudioFormat.CHANNEL_CONFIGURATION_MONO,
                                          AudioFormat.ENCODING_PCM_16BIT,
                                          intSize,
                                          AudioTrack.MODE_STREAM);
                             at.play();
                             at.write(buff, WAVE_HEADER_SIZE, buff.length - WAVE_HEADER_SIZE);
                             at.stop();
                             at.release();
                             at = null;
                             buff = null;
                      }
               }
         } catch (Exception e) {
               e.printStackTrace();
         }
     }

     private void DisplayError(int errorSecurity) {
		// TODO Auto-generated method stub	
     }

     private CbtnOnClick btnOnClick = new CbtnOnClick();
	
     private class CbtnOnClick implements View.OnClickListener {	
    	@Override   
        public void onClick(View v){
			byte[] param 	= new byte[256];
			byte[] retbuff 	= new byte[512];
			byte[] retlen 	= new byte[1];
			byte   paramlen; 

			switch (v.getId()) { 
			case R.id.btnRATS:
				param[0] = (byte) 0x26;
				param[1] = (byte) 0x00;
				if(0 == mSerialPort.CPU_RATS(handle, address, param, retbuff, retlen))
				{
					//soundPool.play(loadId , 15, 15, 1, 0, 1);
					mReception.append("ATS: " + ByteToStr(retlen[0], retbuff) + "\n");			
				}
				else
				{
					mReception.append("RATS  error\n");
				}
				break;
			case R.id.btnAPDU:
				String APDUData = ((EditText)findViewById(R.id.edit_APDU_Value)).getText().toString();
				try {				
					if ( (paramlen = (byte) strToByte(APDUData, param)) == -1) 
					{
					  mReception.append(getString(R.string.error_lengthOfValue).toString());					 			
					  return ;
					}
				}
				finally {
					Log.d("Eebug-ANDROID", "strToByte error");	
				}
				
				if(0 == mSerialPort.CPU_APDU(handle, address, param, paramlen, retbuff, retlen))
				{
					soundPool.play(loadId , 15, 15, 1, 0, 1);
					mReception.append(ByteToStr(retlen[0], retbuff) + "\n");
				}
				else
				{
					mReception.append("APDU  error\n");
					((CheckBox)findViewById(R.id.APDU_AutoFlag)).setChecked(false);
				}
				break;
			case R.id.btnClear:
				mReception.setText("");
				break;
			}		
		}	
     } 

     private int charToByte(char c) {   
    	 return  "0123456789ABCDEF".indexOf(c);   
     }
	
     private int strToByte(String in, byte[] out)
     {
		String str = in.replace(" ", "");
		int byteSize = str.length() / 2;
		char[] hexChars = str.toCharArray(); 
		
		if(out == null || hexChars == null)
		{
			return -1;
		}

		for (int i = 0; i < byteSize; i++) {   
			int pos = i * 2;   
			out[i] = (byte) ((charToByte(hexChars[pos]) << 4 ) | (charToByte(hexChars[pos + 1])));   
		}
		return byteSize;	
     }
	
	private  String  ByteToStr(int byteSize, byte[] in)
    {
   	 	String ret = new String("");
   	 	
   	 	if(in.length < byteSize)
   	 		return ret;
   	 
   	 	for(int i = 0; i < byteSize; i++)
   	 	{
   	 		ret = ret.concat(String.format("%1$02X ", in[i]));
   	 	}
   	 	return ret;   
    }
}